
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "error.h"

#define MAX_POINTS 6

struct figure
{
  unsigned color;
  float coord[MAX_POINTS];
};

struct info
{
  char id;
  char *name;
  int nb_floats;
  char *format;
} infos[] = {{'L', "Ligne", 4, "%s %06x (%g,%g) (%g,%g)\n"},
                    {'T', "Triangle", 6, "%s %06x (%g,%g) (%g,%g) (%g,%g)\n"},
                    {'R', "Rond", 3, "%s %06x (%g,%g) %g\n"},
                    {'C', "Carre", 3, "%s %06x (%g,%g) %g\n"},
                    {'\0', NULL, 0, NULL}};

static int char2fig (char id)
{
  for (int i = 0; infos[i].id != 0; i++)
    if (infos[i].id == id)
      return i;

  exit_with_error ("Character %c is not a valid Figure ID", id);
}

static int footprint (int fig_rank)
{
  return sizeof (unsigned) + infos[fig_rank].nb_floats * sizeof (float);
}

static void print_fig (int fig_rank, struct figure *fig)
{
  struct info *p = infos + fig_rank;

  printf (p->format, p->name, fig->color, fig->coord[0], fig->coord[1],
          fig->coord[2], fig->coord[3], fig->coord[4], fig->coord[5]);
}

void display (char *file, char fig_code)
{
  int fd = open (file, O_RDONLY);
  check (fd, "open");

  for (;;) {
    struct figure fig;
    char id;
    int n;
    
    n = read (fd, &id, 1);
    check (n, "read");
    if (n == 0)
      break;

    int fig_rank = char2fig (id);
    int fig_size = footprint (fig_rank);
    if (id == fig_code) {
      n = read (fd, &fig, fig_size);
      print_fig (fig_rank, &fig);
    } else
      lseek (fd, fig_size, SEEK_CUR);
  }
  close (fd);
}

int main (int argc, char *argv[])
{
  if (argc < 3)
    exit_with_error ("Usage: %s <file> <type>", argv[0]);

  display (argv[1], argv[2][0]);

  return 0;
}
